<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:fn="fn"
    xmlns:pl="http://product-live.com"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:m="http://www.w3.org/2005/xpath-functions"
    version="3.0"
    exclude-result-prefixes="xs fn pl m">
    
    <xsl:output method="json" indent="yes" encoding="UTF-8" />
    
    <xsl:template match="/">
        <!-- First generate an xml as defined above -->
        <xsl:variable name="xmlForJson">
            <!-- It must starts with map and have the xmlns attribute, do not forget m: -->
            <m:map>
                <!-- For string values, use string, the key attribute is the property name, do not forget m: -->
                <m:string key="tableKey"><xsl:value-of select="/Table/@key"/></m:string>
                <!-- For array values, use array, the key attribute is the property name, do not forget m: -->
                <m:array key="items">
                    <xsl:for-each select="/Table/Items/Item">
                        <m:map>
                            <xsl:for-each select="Identifier">
                                <m:string key="{@key}"><xsl:value-of select="string()"/></m:string>
                            </xsl:for-each>
                            <xsl:for-each select="Classification">
                                <m:string key="{@key}"><xsl:value-of select="string()"/></m:string>
                            </xsl:for-each>
                            <xsl:for-each select="Field">
                                <xsl:choose>
                                    <xsl:when test="number() and not(contains(., 'E'))">
                                        <!-- For number values, use number, the key attribute is the property name, do not forget m: -->
                                        <m:number key="{@key}"><xsl:value-of select="number()"/></m:number>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <m:string key="{@key}"><xsl:value-of select="string()"/></m:string>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:for-each>
                        </m:map>
                    </xsl:for-each>
                </m:array>
            </m:map>
        </xsl:variable>
        <!-- The use this function to export it as a valid json file. Special characters will be automatically escaped. You must use copy-of not value-of -->
        <xsl:copy-of select="parse-json(xml-to-json($xmlForJson))"/>
    </xsl:template>
</xsl:stylesheet>